<?php $__env->startSection('content'); ?>
<section>
	<div class="card elevation-0 mb-0">
		<div class="card-body p-0">
			<div class="row">
				<div class="col-12">
					<div class="table-responsive">
						<table class="table table-bordered table-striped mb-0">
							<thead>
								<tr>
									<th class="nowrap"><?php echo e(__('reports.th_reg_no')); ?></th>
									<th><?php echo e(__('reports.th_member_name')); ?></th>
									<th><?php echo e(__('reports.th_phone')); ?></th>
									<th class="nowrap"><?php echo e(__('reports.th_membership_type')); ?></th>
									<th class="nowrap"><?php echo e(__('reports.th_valid_from')); ?></th>
									<th class="nowrap"><?php echo e(__('reports.th_valid_to')); ?></th>
									<th class="nowrap fixed-width-td"><?php echo e(__('reports.th_status')); ?></th>
								</tr>
							</thead>
							<tbody>
								<?php $__currentLoopData = $members; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $member): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
								<tr>
									<td class="align-middle"><?php echo e($member->reg_no); ?></td>
									<td class="align-middle nowrap"><?php echo e($member->name); ?></td>
									<td class="align-middle"><?php echo e($member->phone); ?></td>
									<td class="align-middle nowrap"><?php echo e($member->membership_name); ?></td>
									<td class="align-middle nowrap"><?php echo e(format_date($member->valid_from)); ?></td>
									<td class="align-middle nowrap"><?php echo e(format_date($member->valid_to)); ?></td>
									<td class="align-middle nowrap"><?php echo membership_status_text($member->valid_to); ?>

									</td>
								</tr>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

								<?php if(count($members) == 0): ?>
								<tr>
									<td colspan="11">
										<p class="text-center text-muted mb-0">No Record Found</p>
									</td>
								</tr>
								<?php endif; ?>
							</tbody>
						</table>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('js-script'); ?>
<script>
	window.addEventListener("load", window.print());
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.invoice', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/resources/views/reports/print/member_information.blade.php ENDPATH**/ ?>